//---------------------------------------------------------------------------
#include <vcl.h>
#include <gl.h>
#include <glu.h>
#include <math.h>
//#include <glaux.h>
#pragma hdrstop
#include "uDraw.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//=========================    ========================//
void SetDCPixelFormat(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void DrawAxes(bool Local)
{ GLfloat color[3]; //     
  try
  { glPushMatrix();     //  s 
	glGetFloatv(GL_CURRENT_COLOR, color); //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(3.1, -0.05, 0.1);
		glVertex3f(3.1, 0.05, -0.1);
		glVertex3f(3.1, -0.05, -0.1);
		glVertex3f(3.1, 0.05, 0.1);
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(0.0, 3.1, -0.1);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(0.1, 3.1, 0.1);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(-0.1, 3.1, 0.1);
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(0.1, -0.1, 3.1);
		glVertex3f(-0.1, -0.1, 3.1);
		glVertex3f(0.1, 0.1, 3.1);
		glVertex3f(-0.1, 0.1, 3.1);
		glVertex3f(-0.1, -0.1, 3.1);
		glVertex3f(0.1, 0.1, 3.1);
	glEnd();
  }
  __finally
  { // ³   
	glColor3f(color[0], color[1], color[2]);
	glPopMatrix(); //   
  }
}
//==========================  TColor  RGB========================//
void ColorToRGB(int Color, GLfloat *R, GLfloat *G, GLfloat *B)
{ *R = ((GLfloat) (Color & 0xFF))/255;
  *G = ((GLfloat)((Color & 0xFF00) >> 8))/255;
  *B = ((GLfloat)((Color & 0xFF0000) >> 16))/255;
}
//---------------------------------------------------------------------------
const int Max = 10;
TVector External[Max] =
{{-3.0,-5.0,0.0},
 {5.0,-5.0,0.0},
 {3.0,-2.0,0.0},
 {0.0,-2.0,0.0},
 {5.0,2.0,0.0},
 {3.0,5.0,0.0},
 {-5.0,5.0,0.0},
 {-3.0,2.0,0.0},
 {0.0,2.0,0.0},
 {-5.0,-2.0,0.0}
};
TVector Internal[Max] =
{{-2.5,-4.5,0.0},
 {4.0,-4.5,0.0},
 {2.5,-2.5,0.0},
 {-1.0,-2.5,0.0},
 {3.5,2.5,0.0},
 {2.5,4.5,0.0},
 {-4.0,4.5,0.0},
 {-2.5,2.5,0.0},
 {1.0,2.5,0.0},
 {-4.0,-2.5,0.0}
};
//---------------------------------------------------------------------------
GLuint texture[1];	//    1- 
typedef struct RGBImageRec
{ GLint sizeX, sizeY;
  GLubyte *data;
} TRGBImageRec;
//---------------------------------------------------------------------------
TRGBImageRec *ImageLoad(AnsiString TexFileName)
{ TRGBImageRec *rgbImageRec = NULL;
  Graphics::TBitmap *bitmap = NULL;
  int dx = 0, dy = 0;
  try
  { rgbImageRec = new TRGBImageRec();
	bitmap = new Graphics::TBitmap();
	bitmap->LoadFromFile(TexFileName);
	dx = rgbImageRec->sizeX = bitmap->Width;
	dy = rgbImageRec->sizeY = bitmap->Height;
	rgbImageRec->data=(GLubyte*)malloc(bitmap->Width*bitmap->Height*3*sizeof(GLubyte));
	for(int i = 0; i < dy; i++)
	{ for(int j = 0; j < dx; j++)
	  { *(rgbImageRec->data+(i*dy+j)*3)   = (GLubyte)GetRValue(bitmap->Canvas->Pixels[j][dy-i-1]);
		*(rgbImageRec->data+(i*dy+j)*3+1) = (GLubyte)GetGValue(bitmap->Canvas->Pixels[j][dy-i-1]);
		*(rgbImageRec->data+(i*dy+j)*3+2) = (GLubyte)GetBValue(bitmap->Canvas->Pixels[j][dy-i-1]);
	  }
	}
  }
  __finally
  { delete bitmap;
  }
  return rgbImageRec;
}
//---------------------------------------------------------------------------
void InitLists(void)
{ TRGBImageRec *tex = ImageLoad("..\\Bmp\\KNUBA.bmp");
  glGenTextures(1, texture);
  glBindTexture(GL_TEXTURE_2D, texture[0]);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  //glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
  glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND);
  glRenderMode(GL_RENDER);
  //glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
  //glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
  glTexImage2D(GL_TEXTURE_2D, 0, 3, tex->sizeX, tex->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, tex->data);
  GLUtesselator *gluTess = gluNewTess();
  glNewList(TessList, GL_COMPILE);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
	gluTessCallback(gluTess, GLU_TESS_BEGIN, (void(CALLBACK*)(void))glBegin);
	gluTessCallback(gluTess, GLU_TESS_VERTEX, (void(CALLBACK*)(void))glVertex3dv);
	gluTessCallback(gluTess, GLU_TESS_END, (void(CALLBACK*)(void))glEnd);
	gluTessBeginPolygon(gluTess, NULL);
	  gluTessBeginContour(gluTess);
		for(int i=0; i<Max; i++) gluTessVertex(gluTess, External[i], External[i]);
	  gluTessEndContour(gluTess);
	  gluTessBeginContour(gluTess);
		for(int i=0; i<Max; i++) gluTessVertex(gluTess, Internal[i], Internal[i]);
	  gluTessEndContour(gluTess);
	gluTessEndPolygon(gluTess);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
  glEndList();
  gluDeleteTess(gluTess);
  TVector normal = {0.0, 0.0, 0.0};
  TVector p1, p2, p3;
  glNewList(SquareList, GL_COMPILE);
	glBegin(GL_QUADS);
	for(int i=0; i<Max; i++)
	{ //    
	  p1[0] = External[i][0];
	  p1[1] = External[i][1];
	  p1[2] = External[i][2]-H/2;
	  if(i == Max-1)
	  { p2[0] = External[0][0];
		p2[1] = External[0][1];
		p2[2] = External[0][2]-H/2;
		p3[0] = External[0][0];
		p3[1] = External[0][1];
		p3[2] = External[0][2]+H/2;
	  }
	  else
	  { p2[0] = External[i+1][0];
		p2[1] = External[i+1][1];
		p2[2] = External[i+1][2]-H/2;
		p3[0] = External[i+1][0];
		p3[1] = External[i+1][1];
		p3[2] = External[i+1][2]+H/2;
	  }
	  //     3- 
	  Calc3PointsNormal(p1, p2, p3, normal);
	  //        
	  glNormal3f(normal[0], normal[1], normal[2]);
	  glTexCoord2d (0.0, 0.0);
	  glVertex3f(External[i][0], External[i][1], External[i][2]-H/2);
	  if(i == Max-1)
	  { glTexCoord2d (1.0, 0.0);
		glVertex3f(External[0][0], External[0][1], External[0][2]-H/2);
		glTexCoord2d (1.0, 2.0);
		glVertex3f(External[0][0], External[0][1], External[0][2]+H/2);
	  }
	  else
	  { glTexCoord2d (1.0, 0.0);
		glVertex3f(External[i+1][0], External[i+1][1], External[i+1][2]-H/2);
		glTexCoord2d (1.0, 2.0);
		glVertex3f(External[i+1][0], External[i+1][1], External[i+1][2]+H/2);
	  }
	  glTexCoord2d (0.0, 2.0);
	  glVertex3f(External[i][0], External[i][1], External[i][2]+H/2);
	  //    
	  p3[0] = Internal[i][0];
	  p3[1] = Internal[i][1];
	  p3[2] = Internal[i][2]-H/2;
	  if(i == Max-1)
	  { p2[0] = Internal[0][0];
		p2[1] = Internal[0][1];
		p2[2] = Internal[0][2]-H/2;
		p1[0] = Internal[0][0];
		p1[1] = Internal[0][1];
		p1[2] = Internal[0][2]+H/2;
	  }
	  else
	  { p2[0] = Internal[i+1][0];
		p2[1] = Internal[i+1][1];
		p2[2] = Internal[i+1][2]-H/2;
		p1[0] = Internal[i+1][0];
		p1[1] = Internal[i+1][1];
		p1[2] = Internal[i+1][2]+H/2;
	  }
	  //     3- 
	  Calc3PointsNormal(p1, p2, p3, normal);
	  //        
	  glTexCoord2d (0.0, 0.0);
	  glNormal3f(normal[0], normal[1], normal[2]);
	  glVertex3f(Internal[i][0], Internal[i][1], Internal[i][2]-H/2);
	  if(i == Max-1)
	  { glTexCoord2d (2.0, 0.0);
		glVertex3f(Internal[0][0], Internal[0][1], Internal[0][2]-H/2);
		glTexCoord2d (2.0, 2.0);
		glVertex3f(Internal[0][0], Internal[0][1], Internal[0][2]+H/2);
	  }
	  else
	  { glTexCoord2d (2.0, 0.0);
		glVertex3f(Internal[i+1][0], Internal[i+1][1], Internal[i+1][2]-H/2);
		glTexCoord2d (2.0, 2.0);
		glVertex3f(Internal[i+1][0], Internal[i+1][1], Internal[i+1][2]+H/2);
	  }
	  glTexCoord2d (0.0, 2.0);
	  glVertex3f(Internal[i][0], Internal[i][1], Internal[i][2]+H/2);
	}
	glEnd();
  glEndList();
  delete tex;
}
//====================    ==================//
void Calc3PointsNormal(TVector p1, TVector p2, TVector p3, TVector Normal)
{ GLfloat wrki;
  GLfloat vx1;
  GLfloat vy1;
  GLfloat vz1;
  GLfloat vx2;
  GLfloat vy2;
  GLfloat vz2;
  GLfloat nx;
  GLfloat ny;
  GLfloat nz;
  vx1 = p1[0] - p2[0];
  vy1 = p1[1] - p2[1];
  vz1 = p1[2] - p2[2];
  vx2 = p2[0] - p3[0];
  vy2 = p2[1] - p3[1];
  vz2 = p2[2] - p3[2];
  nx = vy1 * vz2 - vz1 * vy2;
  ny = vz1 * vx2 - vx1 * vz2;
  nz = vx1 * vy2 - vy1 * vx2;
  wrki = sqrt (nx * nx + ny * ny + nz * nz);
  if (wrki <= 1E-8) wrki = 1; //     0.0
  Normal[0] = nx / wrki;
  Normal[1] = ny / wrki;
  Normal[2] = nz / wrki;
}

