//---------------------------------------------------------------------------
#define _USE_MATH_DEFINES
#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
//---------------------------------------------------------------------------
#include "draw.h"
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{ 
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
	glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
const int STR = 20;
const int Max = 10;
typedef GLdouble TVector[3];
TVector Extern[Max] =
{ {-3.0,-5.0,0.0},
 {5.0,-5.0,0.0},
 {3.0,-2.0,0.0},
 {0.0,-2.0,0.0},
 {5.0,2.0,0.0},
 {3.0,5.0,0.0},
 {-5.0,5.0,0.0},
 {-3.0,2.0,0.0},
 {0.0,2.0,0.0},
 {-5.0,-2.0,0.0}
};
TVector Intern[Max] =
{ {-2.5,-4.5,0.0},
 {4.0,-4.5,0.0},
 {2.5,-2.5,0.0},
 {-1.0,-2.5,0.0},
 {3.5,2.5,0.0},
 {2.5,4.5,0.0},
 {-4.0,4.5,0.0},
 {-2.5,2.5,0.0},
 {1.0,2.5,0.0},
 {-4.0,-2.5,0.0}
};
TVector Obj[Max] =
{ {-2.5,-4.5,-1.0},
 {4.0,-4.5,-1.0},
 {2.5,-2.5,-1.0},
 {-1.0,-2.5,-1.0},
 {3.5,2.5,-1.0},
 {2.5,4.5,-1.0},
 {-4.0,4.5,-1.0},
 {-2.5,2.5,-1.0},
 {1.0,2.5,-1.0},
 {-4.0,-2.5,-1.0}
};
//---------------------------------------------------------------------------
void star(GLfloat radius_in, GLfloat radius_ou, TVector* poly, GLubyte count)
{
	GLfloat alpha = 0;
	for (size_t i = 0; i < count; i++)
	{
		alpha = GLfloat(GLdouble(2 * M_PI * i) / count);
		poly[2*i][0] = GLfloat(radius_ou * cos(alpha));
		poly[2*i][1] = GLfloat(radius_ou * sin(alpha));
		poly[2*i][2] = GLfloat(2.0);
		alpha += GLfloat(GLdouble(2 * M_PI) / count) / 2;
		poly[2*i+1][0] = GLfloat(radius_in * cos(alpha));
		poly[2*i+1][1] = GLfloat(radius_in * sin(alpha));
		poly[2*i+1][2] = GLfloat(2.0);
	}
}
//---------------------------------------------------------------------------
void init_lists(void)
{
	TVector* poly = new TVector[2*STR];
	star(1.0, 2.0, poly, STR);
	glNewList(LIST_F, GL_COMPILE);
		GLUtesselator* gluTess = gluNewTess();
		gluTessCallback(gluTess, GLU_TESS_BEGIN, (void(CALLBACK*)(void))glBegin);
		gluTessCallback(gluTess, GLU_TESS_VERTEX, (void(CALLBACK*)(void))glVertex3dv);
		gluTessCallback(gluTess, GLU_TESS_END, (void(CALLBACK*)(void))glEnd);
		glColor3f(GLfloat(0.3), GLfloat(0.4), GLfloat(0.5));
		gluTessBeginPolygon(gluTess, nullptr);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < Max; i++) gluTessVertex(gluTess, Extern[i], Extern[i]);
			gluTessEndContour(gluTess);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < Max; i++) gluTessVertex(gluTess, Intern[i], Intern[i]);
			gluTessEndContour(gluTess);
		gluTessEndPolygon(gluTess);
		glColor3f(GLfloat(1.0), GLfloat(0.4), GLfloat(0.5));
		gluTessBeginPolygon(gluTess, nullptr);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < Max; i++) gluTessVertex(gluTess, Obj[i], Obj[i]);
			gluTessEndContour(gluTess);
		gluTessEndPolygon(gluTess);
		glColor3f(GLfloat(1.0), GLfloat(0.0), GLfloat(0.0));
		gluTessBeginPolygon(gluTess, nullptr);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < 2*STR; i++) gluTessVertex(gluTess, poly[i], poly[i]); // ǳ
			gluTessEndContour(gluTess);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < STR; i++) gluTessVertex(gluTess, poly[2*i+1], poly[2*i+1]); //   
			gluTessEndContour(gluTess);
		gluTessEndPolygon(gluTess);
		gluDeleteTess(gluTess);
	glEndList();
	delete[]poly;

	glNewList(LIST_L, GL_COMPILE);
		glCallList(LIST_F);
	glEndList();

}
//---------------------------------------------------------------------------