//---------------------------------------------------------------------------
#define _USE_MATH_DEFINES
#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
//---------------------------------------------------------------------------
#include "draw.h"
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{ 
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
	glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
void init_lists(void)
{
	glNewList(LIST_F, GL_COMPILE);
		GLUquadric* solar = gluNewQuadric();
		glColor3f(GLfloat(1.0), GLfloat(1.0), GLfloat(0.0));	//  			
		gluQuadricDrawStyle(solar, GLU_FILL);
		gluQuadricNormals(solar, GLU_SMOOTH);
		gluSphere(solar, 0.1, 16, 8);
		gluDeleteQuadric(solar);
	glEndList();

	glNewList(LIST_L, GL_COMPILE);
		glCallList(LIST_F);
	glEndList();
}
//---------------------------------------------------------------------------
void rect_with_hole(GLfloat size_x, GLfloat size_y, GLfloat radius, GLubyte slices)
{
	GLfloat x = 0;
	GLfloat y = 0;
	GLfloat alpha = 0;
	//  
	glBegin(GL_QUAD_STRIP);
	for (size_t i = 0; i <= slices; i++)
	{
		alpha = GLfloat((45.0 - GLdouble(GLdouble(90 * i) / slices)) * M_PI / 180);
		x = GLfloat(radius * cos(alpha));
		y = GLfloat(radius * sin(alpha));
		glVertex2f(x, y);
		x = GLfloat(size_x / 2);
		y = GLfloat(size_y / 2 - (size_y / slices) * i);
		glVertex2f(x, y);
	}
	glEnd();
	// ˳ 
	glBegin(GL_QUAD_STRIP);
	for (size_t i = 0; i <= slices; i++)
	{
		alpha = GLfloat((135.0 + GLdouble(GLdouble(90 * i) / slices)) * M_PI / 180);
		x = GLfloat(radius * cos(alpha));
		y = GLfloat(radius * sin(alpha));
		glVertex2f(x, y);
		x = -GLfloat(size_x / 2);
		y = GLfloat(size_y / 2 - (size_y / slices) * i);
		glVertex2f(x, y);
	}
	glEnd();
	//  
	glBegin(GL_QUAD_STRIP);
	for (size_t i = 0; i <= slices; i++)
	{
		alpha = GLfloat((45.0 + GLdouble(GLdouble(90 * i) / slices)) * M_PI / 180);
		x = GLfloat(radius * cos(alpha));
		y = GLfloat(radius * sin(alpha));
		glVertex2f(x, y);
		x = GLfloat(size_x / 2 - (size_x / slices) * i);
		y = GLfloat(size_y / 2);
		glVertex2f(x, y);
	}
	glEnd();
	//  
	glBegin(GL_QUAD_STRIP);
	for (size_t i = 0; i <= slices; i++)
	{
		alpha = GLfloat((315.0 - GLdouble(GLdouble(90 * i) / slices)) * M_PI / 180);
		x = GLfloat(radius * cos(alpha));
		y = GLfloat(radius * sin(alpha));
		glVertex2f(x, y);
		x = GLfloat(size_x / 2 - (size_x / slices) * i);
		y = -GLfloat(size_y / 2);
		glVertex2f(x, y);
	}
	glEnd();
}
//---------------------------------------------------------------------------
void bar_with_hole(GLfloat size_x, GLfloat size_y, GLfloat size_z, GLfloat radius, GLubyte slices)
{
	glNormal3d(0.0, 0.0, -1.0);
	rect_with_hole(size_x, size_y, radius, 20);
	glPushMatrix();
		glTranslatef(GLfloat(0.0), GLfloat(0.0), size_z);
		glNormal3d(0.0, 0.0, 1.0);
		rect_with_hole(size_x, size_y, radius, 20);
	glPopMatrix();
	glBegin(GL_QUAD_STRIP);
		glVertex3f(GLfloat(-size_x / 2), GLfloat(-size_y / 2), GLfloat(0.0));
		glVertex3f(GLfloat(-size_x / 2), GLfloat(-size_y / 2), size_z);
		glVertex3f(GLfloat(-size_x / 2), GLfloat(size_y / 2), GLfloat(0.0));
		glVertex3f(GLfloat(-size_x / 2), GLfloat(size_y / 2), size_z);
		glVertex3f(GLfloat(size_x / 2), GLfloat(size_y / 2), GLfloat(0.0));
		glVertex3f(GLfloat(size_x / 2), GLfloat(size_y / 2), size_z);
		glVertex3f(GLfloat(size_x / 2), GLfloat(-size_y / 2), GLfloat(0.0));
		glVertex3f(GLfloat(size_x / 2), GLfloat(-size_y / 2), size_z);
		glVertex3f(GLfloat(-size_x / 2), GLfloat(-size_y / 2), GLfloat(0.0));
		glVertex3f(GLfloat(-size_x / 2), GLfloat(-size_y / 2), size_z);
	glEnd();
	GLfloat x = 0;
	GLfloat y = 0;
	GLfloat alpha = 0;
	glBegin(GL_QUAD_STRIP);
	for (size_t i = 0; i <= size_t(slices)*4; i++)
	{
		alpha = GLfloat((45.0 + GLdouble(GLdouble(90 * i) / slices)) * M_PI / 180);
		x = GLfloat(radius * cos(alpha));
		y = GLfloat(radius * sin(alpha));
		glVertex3f(x, y, 0);
		glVertex3f(x, y, size_z);
	}
	glEnd();
}
//---------------------------------------------------------------------------
void draw_figure(GLfloat size_x, GLfloat size_y, GLfloat size_z, GLfloat radius)
{
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	glColor3ub(255, 0, 0);
	glPushMatrix();
		glTranslatef(-size_x / 4, -size_y / 4, GLfloat(0.0));
		bar_with_hole(size_x / 2, size_y / 2, size_z, radius, 20);
	glPopMatrix();
	glColor3ub(0, 255, 0);
	glPushMatrix();
		glTranslatef(-size_x / 4, size_y / 4, GLfloat(0.0));
		bar_with_hole(size_x / 2, size_y / 2, size_z, radius, 20);
	glPopMatrix();
	glColor3ub(0, 0, 255);
	glPushMatrix();
		glTranslatef(size_x / 4, size_y / 4, GLfloat(0.0));
		bar_with_hole(size_x / 2, size_y / 2, size_z, radius, 20);
	glPopMatrix();
	glColor3ub(255, 0, 255);
	glPushMatrix();
		glTranslatef(size_x / 4, -size_y / 4, GLfloat(0.0));
		bar_with_hole(size_x / 2, size_y / 2, size_z, radius, 20);
	glPopMatrix();
}
//---------------------------------------------------------------------------