// gl_template.cpp : Defines the entry point for the application.
//

#include "framework.h"
#include "lab_05.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;                                // current instance
WCHAR szTitle[MAX_LOADSTRING];                  // The title bar text
WCHAR szWindowClass[MAX_LOADSTRING];            // the main window class name

//========================= ,      OpenGL ========================//
HDC   GLDC;    //    
HGLRC GLRC;     //    


UINT Width;
UINT Height;

UINT MouseX;    //    X    
UINT MouseY;    //    Y    

GLfloat Trans[3]; //       

GLfloat Eye[3];    //    ()
GLfloat Center[3]; // ,    ()
GLfloat Up[3];     //    (   OZ)

GLfloat PAngle;    //     OZ
GLfloat QAngle;    //    
GLfloat Distance;  //       

GLfloat Znear;
GLfloat Zfar;
//---------------------------------------------------------------------------

// Forward declarations of functions included in this code module:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
    _In_opt_ HINSTANCE hPrevInstance,
    _In_ LPWSTR    lpCmdLine,
    _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: Place code here.

    // Initialize global strings
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_LAB05, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // Perform application initialization:
    if (!InitInstance(hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_LAB05));

    MSG msg;

    // Main message loop:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return (int)msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc = WndProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = hInstance;
    wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_LAB05));
    wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
    wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
    wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_LAB05);
    wcex.lpszClassName = szWindowClass;
    wcex.hIconSm = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    hInst = hInstance; // Store instance handle in our global variable

    HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
        50, 50, 1000, 1000, nullptr, nullptr, hInstance, nullptr);

    if (!hWnd)
    {
        return FALSE;
    }

    Trans[0] = 0.0;
    Trans[1] = 0.0;
    Trans[2] = 0.0;

    Width = 0;
    Height = 0;

    MouseX = 0;
    MouseY = 0;

    Eye[0] = 5.0;
    Eye[1] = 5.0;
    Eye[2] = 5.0;

    Center[0] = 0.0;
    Center[1] = 0.0;
    Center[2] = 0.0;

    Up[0] = 0.0;
    Up[1] = 0.0;
    Up[2] = 1.0;

    PAngle = 45.0;
    QAngle = 45.0;

    Distance = 10.0;

    Znear = 1.0;
    Zfar = 40.0;
    //-------------------------------------------------------------------------
    GLDC = GetDC(hWnd);  //   
    set_dc_pixel_format(GLDC);   //   
    GLRC = wglCreateContext(GLDC);   //     OpenGL
    wglMakeCurrent(GLDC, GLRC);  //    OpenGL   
    glClearColor(GLclampf(1.0), GLclampf(0.95), GLclampf(0.85), GLclampf(1.0));  //   
    glEnable(GL_DEPTH_TEST);    //   
    init_lists();    //   
    //-------------------------------------------------------------------------
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

    return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE: Processes messages for the main window.
//
//  WM_COMMAND  - process the application menu
//  WM_PAINT    - Paint the main window
//  WM_DESTROY  - post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_COMMAND:
    {
        int wmId = LOWORD(wParam);
        // Parse the menu selections:
        switch (wmId)
        {
        case IDM_ABOUT:
            DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
            break;
        case IDM_EXIT:
            DestroyWindow(hWnd);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
        }
    }
    break;
    case WM_SIZE:
    {
        Width = LOWORD(lParam);
        Height = HIWORD(lParam);
        glViewport(0, 0, Width, Height);    //  
        glMatrixMode(GL_PROJECTION);   //  
        glLoadIdentity();    			 //    1   
        gluPerspective(70.0, Width / Height, Znear, Zfar); // 
        glTranslatef(Trans[0], Trans[1], Trans[2]); //    
        //-------     -------------------//
        Eye[0] = GLfloat(Distance * sin(PAngle * M_PI / 180) * cos(QAngle * M_PI / 180) + Center[0]);
        Eye[1] = GLfloat(Distance * sin(PAngle * M_PI / 180) * sin(QAngle * M_PI / 180) + Center[1]);
        Eye[2] = GLfloat(Distance * cos(PAngle * M_PI / 180) + Center[2]);
        // ,      180 
        int k = (int)PAngle / 360;
        if (PAngle >= 0 + 360 * k && PAngle <= 180 + 360 * k) Up[2] = 1.0; else Up[2] = -1.0;
        //     
        gluLookAt(Eye[0], Eye[1], Eye[2], Center[0], Center[1], Center[2], Up[0], Up[1], Up[2]);
        glMatrixMode(GL_MODELVIEW);   //  
        glLoadIdentity();             //    1   
        //-------------------------------------------------------------------------
        InvalidateRect(hWnd, nullptr, false);   //  
    }
    break;
    case WM_PAINT:
    {
        PAINTSTRUCT ps;
        HDC hdc = BeginPaint(hWnd, &ps);
        // TODO: Add any drawing code that uses hdc here...
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        glPushMatrix();
        //-------------  -----------------------------------------------
        glColor3f(GLfloat(0.0), GLfloat(0.0), GLfloat(0.0));	//  		
        glCallList(LIST_L);
        //draw_axes(true); //      '
        glPopMatrix();
        draw_axes(false); //     
        SwapBuffers(GLDC);
        EndPaint(hWnd, &ps);
    }
    break;
    case WM_KEYDOWN:
    {
        if (wParam == VK_ESCAPE) DestroyWindow(hWnd);
        if (wParam == VK_RIGHT)  Trans[0] += GLfloat(0.05);
        if (wParam == VK_LEFT)   Trans[0] -= GLfloat(0.05);
        if (wParam == VK_UP)     Trans[1] += GLfloat(0.05);
        if (wParam == VK_DOWN)   Trans[1] -= GLfloat(0.05);
        SendMessage(hWnd, WM_SIZE, 0, MAKELONG(Width, Height));
    }
    break;
    case WM_MOUSEMOVE:
    {
        UINT xPos = LOWORD(lParam);
        UINT yPos = HIWORD(lParam);
        if (wParam & MK_LBUTTON)
        {
            Distance = GLfloat(sqrt((GLdouble(Eye[0]) - Center[0]) * (GLdouble(Eye[0]) - Center[0]) +
                (GLdouble(Eye[1]) - Center[1]) * (GLdouble(Eye[1]) - Center[1]) +
                (GLdouble(Eye[2]) - Center[2]) * (GLdouble(Eye[2]) - Center[2])));
            if (MouseX != xPos)
            {
                if (xPos > MouseX) QAngle -= 2; else QAngle += 2;
                MouseX = xPos;
            }
            if (MouseY != yPos)
            {
                if (yPos > MouseY) PAngle -= 2; else PAngle += 2;
                MouseY = yPos;
            }
            SendMessage(hWnd, WM_SIZE, 0, MAKELONG(Width, Height));
        }
    }
    break;
    case WM_MOUSEWHEEL:
    {
        int  zDelta = GET_WHEEL_DELTA_WPARAM(wParam);
        UINT xPos = LOWORD(lParam);
        UINT yPos = HIWORD(lParam);

        if (zDelta > 0)
        {
            Distance -= 1;
            if (Distance <= Znear) Distance = Znear + 1;
            MouseX = xPos;
            MouseY = yPos;
        }
        if (zDelta < 0)
        {
            Distance += 1;
            MouseX = xPos;
            MouseY = yPos;
            if (Distance > Zfar) Distance = Zfar - 1;
        }
        SendMessage(hWnd, WM_SIZE, 0, MAKELONG(Width, Height));
    }
    break;
    case WM_DESTROY:
        glDeleteLists(LIST_F, LIST_L);    //   
        wglMakeCurrent(nullptr, nullptr); // ³      
        wglDeleteContext(GLRC); //    
        ReleaseDC(hWnd, GLDC);  //    OpenGL
        DeleteDC(GLDC); //   
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}
