//---------------------------------------------------------------------------
#include <vcl.h>
#include <gl.h>
#include <glu.h>
//#include <glaux.h>
#include <math.h>
#include <mmsystem.h>
#pragma hdrstop

#include "ufFormGL.h"
#include "uDraw.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormGL *FormGL;
const GLfloat P[4] = {H, 0.0, H/2+2, 1.0};
const GLfloat D[4] = {0.0, 0.0, H, 1.0};
GLint Spin = H;
//---------------------------------------------------------------------------
void TimeCallBack(UINT uTimerID, UINT uMessage, DWORD dwUser, DWORD dw1, DWORD dw2)
{ //Spin -= 1;
  Spin += 1;
  InvalidateRect(FormGL->Handle, NULL, false);
}
//---------------------------------------------------------------------------
__fastcall TFormGL::TFormGL(TComponent* Owner)
				   :TForm(Owner)
{ //---------------- 3D---------------------------------------------------
  FTrans[0] = 0.0;
  FTrans[1] = 0.0;
  FTrans[2] = 0.0;

  FMouseX = 0;
  FMouseY = 0;

  FEye[0] = 5.0;
  FEye[1] = 5.0;
  FEye[2] = 5.0;

  FCenter[0] = 0.0;
  FCenter[1] = 0.0;
  FCenter[2] = 0.0;

  FUp[0] = 0.0;
  FUp[1] = 0.0;
  FUp[2] = 1.0;

  FPAngle = 45.0;
  FQAngle = 45.0;

  FDistance = 17.0;

  FZnear = 1.0;
  FZfar  = 30.0;
  //-------------------------------------------------------------------------
  FGLDC = GetDC(Handle);
  SetDCPixelFormat(FGLDC);
  FHRC = wglCreateContext(FGLDC);
  wglMakeCurrent(FGLDC, FHRC);
  FColor = clBlack; //clCream; //clSkyBlue; //clCream; //0x00E9CEB4;
  ColorToRGB(FColor, &FR, &FG, &FB);
  glClearColor(FR, FG, FB, 1.0);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_TEXTURE_2D);	//   
  glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
  InitLists();
  uTimerId = timeSetEvent (20, 0, TimeCallBack, 0, TIME_PERIODIC);
}
//---------------------------------------------------------------------------
__fastcall TFormGL::~TFormGL(void)
{ timeKillEvent(uTimerId);
  glDeleteLists(TessList, 2);
  wglMakeCurrent(NULL, NULL);
  wglDeleteContext(FHRC);
  ReleaseDC(Handle, FGLDC);
  DeleteDC(FGLDC);
}
//---------------------------------------------------------------------------
void __fastcall TFormGL::FormResize(TObject *Sender)
{ glViewport(0, 0, ClientWidth, ClientHeight);               //  
  //---------------- 3D----------------------------------------------------
  glMatrixMode(GL_PROJECTION);   //  
  glLoadIdentity();    			 //    1   
  gluPerspective(70.0, ClientWidth/ClientHeight, FZnear, FZfar); // 
  glTranslatef(FTrans[0], FTrans[1], FTrans[2]); //    
  //-------     -------------------//
  FEye[0] = FDistance*sin(FPAngle*M_PI/180)*cos(FQAngle*M_PI/180) + FCenter[0];
  FEye[1] = FDistance*sin(FPAngle*M_PI/180)*sin(FQAngle*M_PI/180) + FCenter[1];
  FEye[2] = FDistance*cos(FPAngle*M_PI/180)                       + FCenter[2];
  // ,      180 
  int k = (int)FPAngle/360;
  if(FPAngle>=0+360*k && FPAngle<=180+360*k) FUp[2] = 1.0; else FUp[2] = -1.0;
  //     
  gluLookAt(FEye[0], FEye[1], FEye[2], FCenter[0], FCenter[1], FCenter[2], FUp[0], FUp[1], FUp[2]);
  glMatrixMode(GL_MODELVIEW);   //  
  glLoadIdentity();             //    1   
  //-------------------------------------------------------------------------
  InvalidateRect(Handle, NULL, false);                       //  
}
//---------------------------------------------------------------------------
void __fastcall TFormGL::FormPaint(TObject *Sender)
{ glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix();
	glPushMatrix();
	  glRotatef(Spin, 0.0, 0.0, 1.0);
	  glLightfv(GL_LIGHT0, GL_POSITION, P);
	  /*
	  glTranslatef(P[0], P[1], P[2]);
	  glDisable(GL_LIGHTING);
	  glColor3f(1.0, 1.0, 0.0);
	  auxSolidSphere(0.2);
	  glEnable(GL_LIGHTING);
	  */
	  //glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, D);
	  //glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 45);
	glPopMatrix();
	glColor3f(0.3, 0.7, 0.5);
	//-------------  -----------------------------------------------
	glPushMatrix();
	  glTranslatef(0.0, 0.0, -H/2);
	  glNormal3f(0.0, 0.0, -1.0);
	  glCallList(TessList);
	glPopMatrix();
	glPushMatrix();
	  glNormal3f(0.0, 0.0, 1.0);
	  glTranslatef(0.0, 0.0, H/2);
	  glCallList(TessList);
	glPopMatrix();
	glCallList(SquareList);
	//DrawAxes(true); //      '
  glPopMatrix();
  DrawAxes(false); //     
  SwapBuffers(FGLDC);
}
//---------------------------------------------------------------------------
void __fastcall TFormGL::FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift)
{ if (Key == VK_ESCAPE) Close();
  if (Key == VK_RIGHT)  FTrans[0] += 0.05;
  if (Key == VK_LEFT)   FTrans[0] -= 0.05;
  if (Key == VK_UP)     FTrans[1] += 0.05;
  if (Key == VK_DOWN)   FTrans[1] -= 0.05;
  FormResize(this);
}
//---------------------------------------------------------------------------
void __fastcall TFormGL::FormMouseMove(TObject *Sender, TShiftState Shift, int X, int Y)
{ // ------------------------    3D -----------------------------//
  if(Shift.Contains(ssLeft))
  { FDistance = sqrt((FEye[0]-FCenter[0])*(FEye[0]-FCenter[0]) +
					 (FEye[1]-FCenter[1])*(FEye[1]-FCenter[1]) +
					 (FEye[2]-FCenter[2])*(FEye[2]-FCenter[2]));
	if(FMouseX != X)
	{ if(X>FMouseX) FQAngle -= 2; else FQAngle += 2;
	  FMouseX = X;
	}
	if(FMouseY != Y)
	{ if(Y>FMouseY) FPAngle -= 2; else FPAngle += 2;
	  FMouseY = Y;
	}
	FormResize(this);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormGL::FormMouseWheel(TObject *Sender, TShiftState Shift, int WheelDelta,
		  TPoint &MousePos, bool &Handled)
{ //------      3D -----------------------//
  if(!WheelDelta) return;
  if(WheelDelta > 0)
  { FDistance -= 1;
	if(FDistance <= FZnear) FDistance = FZnear + 1;
	FMouseX = MousePos.x;
	FMouseY = MousePos.y;
  }
  if(WheelDelta < 0)
  {	FDistance += 1;
	FMouseX = MousePos.x;
	FMouseY = MousePos.y;
	if(FDistance > FZfar) FDistance = FZfar - 1;
  }
  FormResize(this);
}
//---------------------------------------------------------------------------
