//---------------------------------------------------------------------------
#include <vcl.h>
#include <gl.h>
#include <glu.h>
#pragma hdrstop
#include "uDraw.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//=========================    ========================//
void SetDCPixelFormat(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void DrawAxes(bool Local)
{ GLfloat color[3]; //     
  try
  { glPushMatrix();     //  s 
	glGetFloatv(GL_CURRENT_COLOR, color); //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(3.1, -0.05, 0.1);
		glVertex3f(3.1, 0.05, -0.1);
		glVertex3f(3.1, -0.05, -0.1);
		glVertex3f(3.1, 0.05, 0.1);
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(0.0, 3.1, -0.1);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(0.1, 3.1, 0.1);
		glVertex3f(0.0, 3.1, 0.0);
		glVertex3f(-0.1, 3.1, 0.1);
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(0.1, -0.1, 3.1);
		glVertex3f(-0.1, -0.1, 3.1);
		glVertex3f(0.1, 0.1, 3.1);
		glVertex3f(-0.1, 0.1, 3.1);
		glVertex3f(-0.1, -0.1, 3.1);
		glVertex3f(0.1, 0.1, 3.1);
	glEnd();
  }
  __finally
  { // ³   
	glColor3f(color[0], color[1], color[2]);
	glPopMatrix(); //   
  }
}
//==========================  TColor  RGB========================//
void ColorToRGB(int Color, GLfloat *R, GLfloat *G, GLfloat *B)
{ *R = ((GLfloat) (Color & 0xFF))/255;
  *G = ((GLfloat)((Color & 0xFF00) >> 8))/255;
  *B = ((GLfloat)((Color & 0xFF0000) >> 16))/255;
}
//---------------------------------------------------------------------------
void InitLists(void)
{ GLUquadricObj *gluQuadric = gluNewQuadric();
  glNewList(QuadricList, GL_COMPILE);
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	glColor3f(0.5, 0.5, 0.5);
	gluSphere(gluQuadric, 1, 20, 20);
	//gluCylinder(gluQuadric, 1, 0.5, 2, 20, 10);
  glEndList();
  gluDeleteQuadric(gluQuadric);
}
//---------------------------------------------------------------------------
