//---------------------------------------------------------------------------
#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
//---------------------------------------------------------------------------
#include "draw.h"
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{ 
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
	glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
void load_texture(GLuint tex, LPCWSTR filename)
{
	HBITMAP hBitmap;
	BITMAP bm;
	//standard bmp 24 bit
	//supported resolutions 64x64, 128x128, 256x256, 512x512

	BYTE R, G, B;

	//LoadImage() loads the bmp picture as an interlaced image
	hBitmap = (HBITMAP)LoadImage(nullptr, filename, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION);

	GetObject(hBitmap, sizeof(BITMAP), &bm);

	//get the address of the start of the image data in memory 
	LPVOID data = bm.bmBits;

	//swap R, G, B values for correct color display
	UINT idx = 0;
	for(UINT i = 0; i < UINT(bm.bmWidth * bm.bmHeight); i++)
	{
		idx = i * 3;
		B = ((BYTE*)data)[idx + 0]; 
		G = ((BYTE*)data)[idx + 1];
		R = ((BYTE*)data)[idx + 2];
		((BYTE*)data)[idx + 0] = R;
		((BYTE*)data)[idx + 1] = G;
		((BYTE*)data)[idx + 2] = B;
	}

	//create texture from loaded bmp image 
	glGenTextures(1, &tex);
	glBindTexture(GL_TEXTURE_2D, tex);

	glTexImage2D(GL_TEXTURE_2D, 0, 4, bm.bmWidth, bm.bmHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, bm.bmBits);

	//texture filtering
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}
//---------------------------------------------------------------------------
const int Max = 10;
point_t Extern[Max] =
{	
	{-3.0,-5.0,0.0},
	{5.0,-5.0,0.0},
	{3.0,-2.0,0.0},
	{0.0,-2.0,0.0},
	{5.0,2.0,0.0},
	{3.0,5.0,0.0},
	{-5.0,5.0,0.0},
	{-3.0,2.0,0.0},
	{0.0,2.0,0.0},
	{-5.0,-2.0,0.0}
};
point_t Intern[Max] =
{ 
	{-2.5,-4.5,0.0},
	{4.0,-4.5,0.0},
	{2.5,-2.5,0.0},
	{-1.0,-2.5,0.0},
	{3.5,2.5,0.0},
	{2.5,4.5,0.0},
	{-4.0,4.5,0.0},
	{-2.5,2.5,0.0},
	{1.0,2.5,0.0},
	{-4.0,-2.5,0.0}
};
//---------------------------------------------------------------------------
void init_lists(void)
{
	glNewList(LIST_F, GL_COMPILE);
		GLUquadric* solar = gluNewQuadric();
		glColor3f(GLfloat(1.0), GLfloat(1.0), GLfloat(0.0));	//  			
		gluQuadricDrawStyle(solar, GLU_FILL);
		gluQuadricNormals(solar, GLU_SMOOTH);
		gluSphere(solar, 0.1, 16, 8);
		gluDeleteQuadric(solar);
	glEndList();

	point_t normal = { 0.0, 0.0, 0.0 };
	point_t p1, p2, p3;

	glNewList(LIST_2, GL_COMPILE);
		glBegin(GL_QUADS);
			for (UINT i = 0; i < Max; i++)
			{ //    
				p1[0] = Extern[i][0];
				p1[1] = Extern[i][1];
				p1[2] = Extern[i][2] - H / 2;
				if (i == Max - 1)
				{
					p2[0] = Extern[0][0];
					p2[1] = Extern[0][1];
					p2[2] = Extern[0][2] - H / 2;
					p3[0] = Extern[0][0];
					p3[1] = Extern[0][1];
					p3[2] = Extern[0][2] + H / 2;
				}
				else
				{
					p2[0] = Extern[i + 1][0];
					p2[1] = Extern[i + 1][1];
					p2[2] = Extern[i + 1][2] - H / 2;
					p3[0] = Extern[i + 1][0];
					p3[1] = Extern[i + 1][1];
					p3[2] = Extern[i + 1][2] + H / 2;
				}
				//     3- 
				calc_normal(p1, p2, p3, normal);
				//        
				glNormal3d(normal[0], normal[1], normal[2]);
				glTexCoord2d(0.0, 0.0);
				glVertex3d(Extern[i][0], Extern[i][1], Extern[i][2] - H / 2);
				if (i == Max - 1)
				{
					glTexCoord2d(1.0, 0.0);
					glVertex3d(Extern[0][0], Extern[0][1], Extern[0][2] - H / 2);
					glTexCoord2d(1.0, 2.0);
					glVertex3d(Extern[0][0], Extern[0][1], Extern[0][2] + H / 2);
				}
				else
				{
					glTexCoord2d(1.0, 0.0);
					glVertex3d(Extern[i + 1][0], Extern[i + 1][1], Extern[i + 1][2] - H / 2);
					glTexCoord2d(1.0, 2.0);
					glVertex3d(Extern[i + 1][0], Extern[i + 1][1], Extern[i + 1][2] + H / 2);
				}
				glTexCoord2d(0.0, 2.0);
				glVertex3d(Extern[i][0], Extern[i][1], Extern[i][2] + H / 2);
				//    
				p3[0] = Intern[i][0];
				p3[1] = Intern[i][1];
				p3[2] = Intern[i][2] - H / 2;
				if (i == Max - 1)
				{
					p2[0] = Intern[0][0];
					p2[1] = Intern[0][1];
					p2[2] = Intern[0][2] - H / 2;
					p1[0] = Intern[0][0];
					p1[1] = Intern[0][1];
					p1[2] = Intern[0][2] + H / 2;
				}
				else
				{
					p2[0] = Intern[i + 1][0];
					p2[1] = Intern[i + 1][1];
					p2[2] = Intern[i + 1][2] - H / 2;
					p1[0] = Intern[i + 1][0];
					p1[1] = Intern[i + 1][1];
					p1[2] = Intern[i + 1][2] + H / 2;
				}
				//     3- 
				calc_normal(p1, p2, p3, normal);
				//        
				glTexCoord2d(0.0, 0.0);
				glNormal3d(normal[0], normal[1], normal[2]);
				glVertex3d(Intern[i][0], Intern[i][1], Intern[i][2] - H / 2);
				if (i == Max - 1)
				{
					glTexCoord2d(2.0, 0.0);
					glVertex3d(Intern[0][0], Intern[0][1], Intern[0][2] - H / 2);
					glTexCoord2d(2.0, 2.0);
					glVertex3d(Intern[0][0], Intern[0][1], Intern[0][2] + H / 2);
				}
				else
				{
					glTexCoord2d(2.0, 0.0);
					glVertex3d(Intern[i + 1][0], Intern[i + 1][1], Intern[i + 1][2] - H / 2);
					glTexCoord2d(2.0, 2.0);
					glVertex3d(Intern[i + 1][0], Intern[i + 1][1], Intern[i + 1][2] + H / 2);
				}
				glTexCoord2d(0.0, 2.0);
				glVertex3d(Intern[i][0], Intern[i][1], Intern[i][2] + H / 2);
			}
		glEnd();
	glEndList();

	glNewList(LIST_3, GL_COMPILE);
		GLUtesselator* gluTess = gluNewTess();
		glEnable(GL_TEXTURE_GEN_S);
		glEnable(GL_TEXTURE_GEN_T);
		gluTessCallback(gluTess, GLU_TESS_BEGIN, (void(CALLBACK*)(void))glBegin);
		gluTessCallback(gluTess, GLU_TESS_VERTEX, (void(CALLBACK*)(void))glVertex3dv);
		gluTessCallback(gluTess, GLU_TESS_END, (void(CALLBACK*)(void))glEnd);
		gluTessBeginPolygon(gluTess, NULL);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < Max; i++) gluTessVertex(gluTess, Extern[i], Extern[i]);
			gluTessEndContour(gluTess);
			gluTessBeginContour(gluTess);
				for (int i = 0; i < Max; i++) gluTessVertex(gluTess, Intern[i], Intern[i]);
			gluTessEndContour(gluTess);
		gluTessEndPolygon(gluTess);
		glDisable(GL_TEXTURE_GEN_S);
		glDisable(GL_TEXTURE_GEN_T);
		gluDeleteTess(gluTess);
	glEndList();

	glNewList(LIST_L, GL_COMPILE);
		glEnable(GL_LIGHTING);  //  	
		glEnable(GL_TEXTURE_2D);	//   
		glColor3f(GLfloat(1.0), GLfloat(1.0), GLfloat(1.0));	// 		
		glPushMatrix();
			glTranslated(0.0, 0.0, -H / 2);
			glNormal3d(0.0, 0.0, -1.0);
			glCallList(LIST_3);
		glPopMatrix();
		glPushMatrix();
			glNormal3d(0.0, 0.0, 1.0);
			glTranslated(0.0, 0.0, H / 2);
			glCallList(LIST_3);
		glPopMatrix();
		glCallList(LIST_2);
		glDisable(GL_TEXTURE_2D);	//  
		glDisable(GL_LIGHTING); // 
	glEndList();
}
//---------------------------------------------------------------------------
void calc_normal(point_t p1, point_t p2, point_t p3, point_t normal)
{
	GLfloat wrki = 0.0;
	GLfloat vx1 = 0.0;
	GLfloat vy1 = 0.0;
	GLfloat vz1 = 0.0;
	GLfloat vx2 = 0.0;
	GLfloat vy2 = 0.0;
	GLfloat vz2 = 0.0;
	GLfloat nx = 0.0;
	GLfloat ny = 0.0;
	GLfloat nz = 0.0;
	vx1 = GLfloat(p1[0] - p2[0]);
	vy1 = GLfloat(p1[1] - p2[1]);
	vz1 = GLfloat(p1[2] - p2[2]);
	vx2 = GLfloat(p2[0] - p3[0]);
	vy2 = GLfloat(p2[1] - p3[1]);
	vz2 = GLfloat(p2[2] - p3[2]);
	nx = vy1 * vz2 - vz1 * vy2;
	ny = vz1 * vx2 - vx1 * vz2;
	nz = vx1 * vy2 - vy1 * vx2;
	wrki = GLfloat(sqrt(GLdouble(nx) * nx + GLdouble(ny) * ny + GLdouble(nz) * nz));
	if (wrki <= 1E-8) wrki = 1; //     0.0
	normal[0] = nx / wrki;
	normal[1] = ny / wrki;
	normal[2] = nz / wrki;
}
//---------------------------------------------------------------------------