//---------------------------------------------------------------------------
#include <windows.h>
#include <GL/gl.h>
//---------------------------------------------------------------------------
#include "draw.h"
//---------------------------------------------------------------------------
GLubyte Mask[128] =
{
	0x80,	0x00,	0x00,	0x00,
	0x40,	0x00,	0x00,	0x00,
	0x20,	0x00,	0x00,	0x00,
	0x1F,	0xFF,	0x00,	0x00,
	0x08,	0x00,	0x01,	0xF0,
	0x04,	0x00,	0x02,	0x08,
	0x06,	0x00,	0x04,	0x04,
	0x05,	0x00,	0x08,	0x02,

	0x04,	0x80,	0x10,	0x01,
	0x04,	0x40,	0x20,	0x03,
	0x04,	0x20,	0x40,	0x05,
	0x04,	0x10,	0x80,	0x09,
	0x04,	0x0B,	0x00,	0x11,
	0x04,	0x04,	0x00,	0x21,
	0x04,	0x0A,	0x00,	0x41,
	0x04,	0x09,	0x00,	0x81,

	0x00,	0x10,	0x01,	0x01,
	0x00,	0x20,	0x02,	0x03,
	0x00,	0x40,	0x04,	0x05,
	0x00,	0x80,	0x08,	0x09,
	0x01,	0x00,	0x10,	0x11,
	0x02,	0x00,	0x20,	0x21,
	0x04,	0x00,	0x40,	0x41,
	0x08,	0x00,	0x80,	0x81,

	0x08,	0x01,	0x01,	0x01,
	0x08,	0x02,	0x02,	0x02,
	0x08,	0x04,	0x04,	0x04,
	0x08,	0x08,	0x08,	0x08,
	0x04,	0x10,	0x10,	0x16,
	0x02,	0x20,	0x20,	0x28,
	0x01,	0x40,	0x40,	0x48,
	0x00,	0xFF,	0xFf,	0x80
};
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{ 
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
	glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
void init_lists(void)
{
	glNewList(LIST_F, GL_COMPILE_AND_EXECUTE);
		glBegin(GL_QUADS);
			glVertex2f(GLfloat(-1.0), GLfloat(-1.0));
			glVertex2f(GLfloat(-1.0), GLfloat(1.0));
			glVertex2f(GLfloat(-0.5), GLfloat(0.5));
			glVertex2f(GLfloat(-0.5), GLfloat(-0.5));
		glEnd();
	glEndList();

	glNewList(LIST_2, GL_COMPILE_AND_EXECUTE);
		glPushMatrix();
			glCallList(LIST_F);
			glRotatef(GLfloat(90.0), GLfloat(0.0), GLfloat(0.0), GLfloat(0.1)); //	 
			glCallList(LIST_F);
			glRotatef(GLfloat(90.0), GLfloat(0.0), GLfloat(0.0), GLfloat(0.1)); //	 
			glCallList(LIST_F);
			glRotatef(GLfloat(90.0), GLfloat(0.0), GLfloat(0.0), GLfloat(0.1)); //	 
			glCallList(LIST_F);
		glPopMatrix();
	glEndList();

	glNewList(LIST_3, GL_COMPILE_AND_EXECUTE);
		glLineWidth(GLfloat(3.0)); //  
		glBegin(GL_LINE_LOOP);
			glVertex2f(GLfloat(-1.0), GLfloat(-1.0));
			glVertex2f(GLfloat(-1.0), GLfloat(1.0));
			glVertex2f(GLfloat(1.0), GLfloat(1.0));
			glVertex2f(GLfloat(1.0), GLfloat(-1.0));
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(GLfloat(-0.5), GLfloat(-0.5));
			glVertex2f(GLfloat(-0.5), GLfloat(0.5));
			glVertex2f(GLfloat(0.5), GLfloat(0.5));
			glVertex2f(GLfloat(0.5), GLfloat(-0.5));
		glEnd();
		glBegin(GL_LINES);
			glVertex2f(GLfloat(-0.5), GLfloat(0.2));
			glVertex2f(GLfloat(0.5), GLfloat(0.2));
			glVertex2f(GLfloat(0.0), GLfloat(-0.5));
			glVertex2f(GLfloat(0.0), GLfloat(0.2));
		glEnd();
	glEndList();

	glNewList(LIST_L, GL_COMPILE_AND_EXECUTE);
		glColor3f(GLfloat(1.0), GLfloat(0.5), GLfloat(0.0));	//  		
		glCallList(LIST_2);
		glColor3f(GLfloat(0.0), GLfloat(0.0), GLfloat(0.0));	//  	
		glPolygonStipple(Mask);
		glEnable(GL_POLYGON_STIPPLE);
		glCallList(LIST_2);
		glDisable(GL_POLYGON_STIPPLE);
		glCallList(LIST_3);
	glEndList();

}
//---------------------------------------------------------------------------