//---------------------------------------------------------------------------
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
//---------------------------------------------------------------------------
#include "draw.h"
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{
	PIXELFORMATDESCRIPTOR pfd, * ppfd; int iPF;
	ppfd = &pfd;
	ppfd->nSize = sizeof(PIXELFORMATDESCRIPTOR);
	ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	iPF = ChoosePixelFormat(hdc, ppfd);
	SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
		glScalef(0.75, 0.75, 0.75); //     
		glBegin(GL_LINES);
			if (Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
			glVertex3f(0, 0, 0);
			glVertex3f(3, 0, 0);
			if (Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
			glVertex3f(0, 0, 0);
			glVertex3f(0, 3, 0);
			if (Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
			glVertex3f(0, 0, 0);
			glVertex3f(0, 0, 3);
		glEnd();
		//  X
		if (Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
		glBegin(GL_LINES);
			glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
			glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
			glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
			glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
		glEnd();
		//  Y
		if (Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
		glBegin(GL_LINES);
			glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
			glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
			glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
			glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
			glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
			glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
		glEnd();
		//  Z
		if (Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
		glBegin(GL_LINES);
			glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
			glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
			glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
			glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
			glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
			glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
void init_lists(void)
{
	glNewList(LIST_F, GL_COMPILE);
		GLUquadric* solar = gluNewQuadric();
		glColor3f(GLfloat(1.0), GLfloat(1.0), GLfloat(0.0));	//  			
		gluQuadricDrawStyle(solar, GLU_FILL);
		gluQuadricNormals(solar, GLU_SMOOTH);
		gluSphere(solar, 0.1, 16, 8);
		gluDeleteQuadric(solar);
	glEndList();

	glNewList(LIST_2, GL_COMPILE);
		glBegin(GL_QUADS);
			glVertex3f(GLfloat(-4.0), GLfloat(-3.0), GLfloat(4.0));
			glVertex3f(GLfloat(4.0), GLfloat(-3.0), GLfloat(4.0));
			glVertex3f(GLfloat(4.0), GLfloat(-3.0), GLfloat(-4.0));
			glVertex3f(GLfloat(-4.0), GLfloat(-3.0), GLfloat(-4.0));
		glEnd();
	glEndList();

	glNewList(LIST_3, GL_COMPILE);
		GLUquadric* palnet = gluNewQuadric();
		gluQuadricDrawStyle(palnet, GLU_FILL);
		gluQuadricNormals(palnet, GLU_SMOOTH);
		gluSphere(palnet, 1.0, 20, 10);
		gluDeleteQuadric(palnet);
	glEndList();

	glNewList(LIST_L, GL_COMPILE);
		glEnable(GL_LIGHTING);  //  	
		glColor3f(GLfloat(1.0), GLfloat(0.5), GLfloat(0.2));	// 		
		glCallList(LIST_3);
		glDisable(GL_LIGHTING); // 
	glEndList();
}
//---------------------------------------------------------------------------
void mirror_matrix(point_t point, point_t normal, matrix_t matrix)
{
	GLfloat p    = point[0] * normal[0] + point[1] * normal[1] + point[2] * normal[2];
	matrix[0][0] = GLfloat(1.0 - 2 * GLdouble(normal[0]) * normal[0]);
	matrix[1][0] = GLfloat(0.0 - 2 * GLdouble(normal[0]) * normal[1]);
	matrix[2][0] = GLfloat(0.0 - 2 * GLdouble(normal[0]) * normal[2]);
	matrix[3][0] = GLfloat(2.0 * p * GLdouble(normal[0]));
	matrix[0][1] = GLfloat(0.0 - 2 * GLdouble(normal[0]) * normal[1]);
	matrix[1][1] = GLfloat(1.0 - 2 * GLdouble(normal[1]) * normal[1]);
	matrix[2][1] = GLfloat(0.0 - 2 * GLdouble(normal[1]) * normal[2]);
	matrix[3][1] = GLfloat(2.0 * p * GLdouble(normal[1]));
	matrix[0][2] = GLfloat(0.0 - 2 * GLdouble(normal[0]) * normal[2]);
	matrix[1][2] = GLfloat(0.0 - 2 * GLdouble(normal[1]) * normal[2]);
	matrix[2][2] = GLfloat(1.0 - 2 * GLdouble(normal[2]) * normal[2]);
	matrix[3][2] = GLfloat(2.0 * p * GLdouble(normal[2]));
	matrix[0][3] = GLfloat(0.0);
	matrix[1][3] = GLfloat(0.0);
	matrix[2][3] = GLfloat(0.0);
	matrix[3][3] = GLfloat(1.0);
}
//---------------------------------------------------------------------------