//---------------------------------------------------------------------------
#include <windows.h>
#include <GL/gl.h>
//---------------------------------------------------------------------------
#include "draw.h"
//=========================    ========================//
void set_dc_pixel_format(HDC hdc)
{ PIXELFORMATDESCRIPTOR pfd, *ppfd; int iPF;
  ppfd = &pfd;
  ppfd->nSize   = sizeof(PIXELFORMATDESCRIPTOR);
  ppfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  iPF = ChoosePixelFormat(hdc, ppfd);
  SetPixelFormat(hdc, iPF, ppfd);
}
//==============================   ==============================//
void draw_axes(bool Local)
{ 
	glLineWidth(GLfloat(0.1)); //  
	glPushMatrix();     //   
	glScalef(0.75, 0.75, 0.75); //     
	glBegin(GL_LINES);
		if(Local) glColor3f(0, 0, 0); else glColor3f (1, 0, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(3, 0, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 1, 0);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 3, 0);
		if(Local) glColor3f(0, 0, 0); else glColor3f (0, 0, 1);
		glVertex3f(0, 0, 0);
		glVertex3f(0, 0, 3);
	glEnd();
	//  X
	if(Local) glColor3f(0, 0, 0); else glColor3f(1, 0, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(-0.05), GLfloat(-0.1));
		glVertex3f(GLfloat(3.1), GLfloat(0.05), GLfloat(0.1));
	glEnd();
	//  Y
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 1, 0);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(-0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(0.1), GLfloat(3.1), GLfloat(0.1));
		glVertex3f(GLfloat(0.0), GLfloat(3.1), GLfloat(0.0));
		glVertex3f(GLfloat(-0.1), GLfloat(3.1), GLfloat(0.1));
	glEnd();
	//  Z
	if(Local) glColor3f(0, 0, 0); else glColor3f(0, 0, 1);
	glBegin(GL_LINES);
		glVertex3f(GLfloat(0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(0.1), GLfloat(3.1));
		glVertex3f(GLfloat(-0.1), GLfloat(-0.1), GLfloat(3.1));
		glVertex3f(GLfloat(0.1), GLfloat(0.1), GLfloat(3.1));
	glEnd();
	glPopMatrix(); //   
}
//---------------------------------------------------------------------------
void init_lists(void)
{
	glNewList(LIST_F, GL_COMPILE);
		glColor3ub(200, 50, 200);
		glBegin(GL_TRIANGLES);
			glVertex3f(GLfloat(0.0), GLfloat(0.0), GLfloat(1.0));
			glVertex3f(GLfloat(1.0), GLfloat(0.0), GLfloat(0.0));
			glVertex3f(GLfloat(0.0), GLfloat(1.0), GLfloat(0.0));
		glEnd();
	glEndList();

	glNewList(LIST_2, GL_COMPILE);
		glBegin(GL_TRIANGLES);
			glVertex3f(GLfloat(0.0), GLfloat(0.0), GLfloat(0.0));
			glVertex3f(GLfloat(1.0), GLfloat(0.0), GLfloat(0.0));
			glVertex3f(GLfloat(0.0), GLfloat(1.0), GLfloat(0.0));
		glEnd();
	glEndList();

	glNewList(LIST_L, GL_COMPILE);
		glCallList(LIST_F);
		glColor3ub(255, 0, 0);
		glCallList(LIST_2);
		glPushMatrix();
			glRotatef(90, 1.0, 0.0, 0.0);
			//draw_axes(true);
			glColor3ub(0, 0, 255);
			glCallList(LIST_2);
		glPopMatrix();
		glPushMatrix();
			glRotatef(-90, 0.0, 1.0, 0.0);
			//draw_axes(true);
			glColor3ub(0, 255, 0);
			glCallList(LIST_2);
		glPopMatrix();
	glEndList();

}
//---------------------------------------------------------------------------